/*:
 * @target MZ
 * @plugindesc Prevents player movement with the mouse and touch input. WARNING: DO NOT REDISTRIBUTE OR EDIT THIS PLUGIN UNDER ANY CIRCUMSTANCES.
 * @author Xynteract Dynamics
 * @help This plugin disables player movement using the mouse and touch input.
 *
 * (\   /)
 *  (\ /)
 *   (-)
 *  (/ \)
 * (/   \)
 *
 * This plugin works by overriding the default methods responsible for handling
 * mouse and touch inputs that move the player character. Specifically, it overrides
 * the 'setDestination' method in the 'Game_Temp' class and the 'processMapTouch' 
 * method in the 'Scene_Map' class.
 *
 * The 'setDestination' method is called whenever the player clicks on the map 
 * to move the character. By replacing this method with an empty function, we 
 * effectively disable mouse-based movement.
 *
 * Similarly, the 'processMapTouch' method is responsible for processing touch input
 * on the map scene. By overriding this method with an empty function, we disable 
 * touch-based movement.
 *
 * Additionally, the plugin logs a message to the console whenever an attempt
 * to use mouse or touch input is detected.
 *
 * WARNING: DO NOT REDISTRIBUTE OR EDIT THIS PLUGIN UNDER ANY CIRCUMSTANCES.
 * FAILURE TO COMPLY MAY RESULT IN UNEXPECTED CONSEQUENCES.
 */

(() => {
    // Override the method responsible for mouse and touch movement
    const _Game_Temp_setDestination = Game_Temp.prototype.setDestination;
    Game_Temp.prototype.setDestination = function(x, y) {
        console.log("Mouse/touch movement attempt detected and blocked.");
        // Do nothing, effectively disabling mouse/touch movement
    };

    // Disable the touch input handling in Scene_Map
    const _Scene_Map_processMapTouch = Scene_Map.prototype.processMapTouch;
    Scene_Map.prototype.processMapTouch = function() {
        console.log("Touch input detected and blocked.");
        // Do nothing, effectively disabling touch movement
    };
})();
